package com.changhong.tvos.service;

import com.changhong.tvos.model.InputSourceModel;
import com.changhong.tvos.model.EnumInputSource;
import com.changhong.tvos.model.EnumPipMode;
import com.changhong.tvos.model.EnumPipReturn;
import com.changhong.tvos.model.VideoWindowInfo;
import com.changhong.tvos.model.VideoInfo;
import com.changhong.tvos.model.EnumResource;
import com.changhong.tvos.model.PanelInfo;
import com.changhong.tvos.model.ScheduleTask;
import com.changhong.tvos.model.ATVChannelInfo;
import com.changhong.tvos.model.CaptureWindowInfo;
import com.changhong.tvos.model.TVOSVersion;
import com.changhong.tvos.model.DTVChannelInfo;
import com.changhong.tvos.model.CHMWVersion;
import com.changhong.tvos.model.dtv.TimerInfo;
import com.changhong.tvos.dtv.for3rd.InterTimerInfo;
import android.content.Intent;

interface ITVService {
    //Player
    boolean play(int iChannelNum);
	boolean playNextChannel(boolean bUp);
	void muteVideo(boolean bEnable);
	void muteVideoDelay(int muteMillis);
	boolean getInputSourceList(inout InputSourceModel inputSourceModel);
	boolean startInputSource(int iInputSource, int iChannelNum, boolean bStartAutoScan, boolean bCECReturnLastInputSource);
	boolean returnLastInputSource(boolean bPipInputSource);
	boolean isScanning();
	int getSourceWatchedTimes(in EnumInputSource inputSource);
	void setSourceWatchedTimes(in EnumInputSource inputSource,int times);
	void setSmartSourceOnOff(boolean smartSourceOnOff);
    boolean getSmartSourceOnOff();
    int getCurChannelNum();
    int getNextChannelNum(int iChannelNum, boolean bUp);   
    boolean isATVFavorite();
    void setATVFavorite(boolean bFavorite);
	boolean getPipPopSupportedSourceList(in EnumPipMode ePipPopMode, in EnumInputSource eInputSrc, inout InputSourceModel inputSourceModel);
	EnumPipReturn enablePip(in EnumInputSource eMainInputSrc, in EnumInputSource eSubInputSrc, in VideoWindowInfo videoInfo);
	EnumPipReturn enablePop(in EnumInputSource eMainInputSrc, in EnumInputSource eSubInputSrc);
	boolean setPipSubWindow(in VideoWindowInfo dispWinInfo);
	boolean switchFocusWindow(boolean bMainWindow);
	String getLivePlayerName();
	void updateAudiopath(int iInputSource);
	boolean selectInputSource(int iInputSource);
	
    //Misc
    PanelInfo getPanelInfo(out PanelInfo panelinfo);
	int getDebugLevel();
	void setDebugLevel(int level);
	void savePanelName(String PanelName);
	void enterPCSleep();
 	void setFactoryMode(boolean factoryMode);
	boolean isPanelCompensation(boolean bStandby);
	void startPanelCompensation();
	void startPanelCompensationWhenStandby();
	int getNonePanelCompensationTime();
	int getPanelCompensationCount();
	boolean cheackTvStatus();
	String getDRMKEY();
	void setFactoryShow(boolean isFactoryShow);
    boolean startOLEDPanelCompensationIfNeed(boolean bopen);
    int getPanelOpenTimeJB();
	boolean startJB();
   	int getFactoryAm();
	boolean setFactoryAm(int value);
	void resetPowerOnLogo();
	void setUserSleepTimer(int timer);
	int getUserSleepTimer();
	void disableUserSleepTimer();
	int getUserSleepTimerStage();
	boolean systemReset(int flag);
	int systemResetCheck();
	boolean getBootupCompensation();
	void setBootupCompensation(boolean val);
        int getPanelCompensationCountJb();
        void setXiriVoiceBroadcastState(boolean isBroadcastting, boolean isBgMute);
	void setSoundEffectGroup(int effectGroup);
	
   	//system
   	void systemStandby(boolean bSleep);
   	boolean postSystemKeyEvent(int keyCode);
   	boolean restorePlayerScenes(boolean bBackgroudPlay);
   	String[] getSettingUnResetPackages();
   	String[] getFactoryUnResetPackages();
   	boolean resetTVOSIntSettings(int iMask);
   	boolean enterFactoryMode();
   	void enterSetting();
   	void enterCommonSetting();
   	boolean isAtvDtvApkRunning();
   	boolean isAtvDtvMainActivityRunning();
   	void updateKeyboardConvertFlag(boolean flag);
	boolean suspendStr();
	boolean resumeStr();
	long getLastKeyTime();
	void sleep(boolean bMirrorOn);
	void wakeup();
	void systemReady();
   	boolean setApStatus(boolean bApAtHomeFlag);
        void sendBroadcast(in Intent intent);
        void setPanelPowerOnStatus(boolean bopen);
    int getSoundEffectGroupDefault();
    
	//DTV
	boolean isSupportDTV();
   	String getDTVCardStatus();
   	long getDTVTime();
	List<DTVChannelInfo> getDTVChannelListType(int type);
	DTVChannelInfo getDtvChannelInfo();
	void setTVchanelInfo(in DTVChannelInfo info);
	void setDTVPlayingInfo (String strChannelName, String strProgramName);
	void addAnScheduleTask (in ScheduleTask task);
   	void delAnScheduleTask (in ScheduleTask task);
   	List<ScheduleTask> getTaskList(int iTaskType);
    boolean playDTV(int channel);
    void setDTVCurrentChannel(int channel);
   	int getDTVCurrentChannel();
   	int getChannelCount();
   	int addTimer(in TimerInfo timer);
    int deleteTimer(in TimerInfo timer);
    List<TimerInfo> getTimerList(int type);
    int deleteAllTimer();
    int delAllBaseChannels();
    
    int getFactoryAmTime();
    int getFactoryAmPowerBreakDownTimes();
    int getFactoryAmHighestCpuTemperature();
    void resetFactoryAmHighestCpuTemperature();
    void saveShopMode(boolean bShopMode);
    int getBTFacPairThreshold();
    int getBTUserPairThreshold();
    boolean resetAT();
}
